{*
*  @author ASData.sk <info@asdata,sk>
*  @copyright  2007-2018 ASData.sk
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}


{capture name=path}
	<a href="{$link->getPageLink('order', true, NULL, 'step=3')|escape:'html':'UTF-8'}" title="{l s='Go back to the Checkout' mod='paybysquare'}">{l s='Checkout' mod='paybysquare'}</a><span class="navigation-pipe">{$navigationPipe}</span>{l s='PayBySquare payment' mod='paybysquare'}
{/capture}


<h2>{l s='Order summary' mod='paybysquare'}</h2>

{assign var='current_step' value='payment'}


{if $nbProducts <= 0}
	<p class="warning">{l s='Your shopping cart is empty.' mod='paybysquare'}</p>
{else}
<!--
<h3>{l s='PayBySquare payment' mod='paybysquare'} <small>{l s='Here is a short summary of your order:' mod='paybysquare'}</small> </h3>

	{include file='../api/cart_summary.tpl'}
	{include file='../api/address_summary.tpl'}
-->
<p>
	{l s='Bank wire account information and QR code for payment, will be displayed on the next page.' mod='paybysquare'}
	<br /><br />
	<b>{l s='Please confirm your order by clicking "I confirm my order".' mod='paybysquare'}</b>
</p>

<hr>

<p class="cart_navigation" id="cart_navigation">

	<a class="btn btn-default btn-lg" href="{$link->getPageLink('order', true, NULL, 'step=3')|escape:'html'}" >
		{l s='Other payment methods' mod='paybysquare'}
	</a>

	<a class="pull-right btn btn-success btn-lg" href="{$link->getModuleLink('paybysquare', 'confirmation', ['cart_id' => $cart_id, 'secure_key' => $secure_key], true)|escape:'htmlall':'UTF-8'}" title="{l s='Confirm' mod='paybysquare'}">
		<strong>{l s='I confirm my order' mod='paybysquare'}</strong>
	</a>
</p>

{/if}
