{*
*  @author ASData.sk <info@asdata,sk>
*  @copyright  2007-2018 ASData.sk
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}

{if $type == 'order'}
    <h2>{l s='Order' mod='paybysquare'} # {$object_id|escape:'htmlall':'UTF-8'} ( {$order_date_parsed} ) </h2>
{/if}

<table cellspacing="0" cellpadding="6" style="width:100%;font-family:Arial,sans-serif;color:#636363;border:1px solid #e5e5e5" border="1">
    <thead>
        <tr>
            <th scope="col" style="text-align:left;color:#636363;border:1px solid #e5e5e5;padding:12px">{l s='Product' mod='paybysquare'}</th>
            <th scope="col" style="text-align:left;color:#636363;border:1px solid #e5e5e5;padding:12px">{l s='Quantity' mod='paybysquare'}</th>
            <th scope="col" style="text-align:left;color:#636363;border:1px solid #e5e5e5;padding:12px">{l s='Price' mod='paybysquare'}</th>
        </tr>
    </thead>
<tbody>
                    
{foreach from=$product_detail item=product}
    
    <tr>
       <td style="text-align:left;vertical-align:middle;border:1px solid #eee;word-wrap:break-word;color:#636363;padding:12px">
           {$product['name']|escape:'htmlall':'UTF-8'}
       </td>
       <td style="text-align:left;vertical-align:middle;border:1px solid #eee;color:#636363;padding:12px">
          {$product['cart_quantity']|escape:'htmlall':'UTF-8'}
       </td>
       <td style="text-align:left;vertical-align:middle;border:1px solid #eee;color:#636363;padding:12px">
           <span class="amount">
               {$product['total_wt_formatted']|escape:'htmlall':'UTF-8'}
           </span>
       </td>
    </tr>

{/foreach}
                   
</tbody>
    <tfoot>
        <tr>
            <th scope="row" colspan="2" style="text-align:left;border-top-width:4px;color:#636363;border:1px solid #e5e5e5;padding:12px">
                {l s='Subtotal' mod='paybysquare'}:
            </th>
            <td style="text-align:left;border-top-width:4px;color:#636363;border:1px solid #e5e5e5;padding:12px">
                <span class="amount"> {$only_products|escape:'htmlall':'UTF-8'} </span>
            </td>
        </tr>
        <tr>
            <th scope="row" colspan="2" style="text-align:left;color:#636363;border:1px solid #e5e5e5;padding:12px">
                {l s='Shipping' mod='paybysquare'}:
            </th>
            <td  style="text-align:left;color:#636363;border:1px solid #e5e5e5;padding:12px">
                <span class="shipping"> {if $shipping == '0'}{l s='Free Shipping!' mod='paybysquare'}{else}{$shipping|escape:'htmlall':'UTF-8'}{/if} </span>
            </td>
        </tr>
        {if $total_discounts != 0}
        <tr>    
            <th scope="row" colspan="2" style="text-align:left;color:#636363;border:1px solid #e5e5e5;padding:12px">
                {l s='Discounts' mod='paybysquare'}:
            </th>
            <td  style="text-align:left;color:#636363;border:1px solid #e5e5e5;padding:12px">
                <span class="total_discounts"> - {$total_discounts|escape:'htmlall':'UTF-8'} </span>
            </td>
        </tr>
        {/if}
        <tr>
            <th scope="row" colspan="2" style="text-align:left;color:#636363;border:1px solid #e5e5e5;padding:12px">
                {l s='Payment method' mod='paybysquare'}:
            </th>
            <td style="text-align:left;color:#636363;border:1px solid #e5e5e5;padding:12px">
                <span>PayBySquare</span>
            </td>
        </tr>
        <tr>
            <th scope="row" colspan="2" style="text-align:left;color:#636363;border:1px solid #e5e5e5;padding:12px">
                {l s='Total' mod='paybysquare'}:
            </th>
            <td style="text-align:left;color:#636363;border:1px solid #e5e5e5;padding:12px">
                <span> {$total_order|escape:'htmlall':'UTF-8'} </span>
            </td>
        </tr>
    </tfoot>
</table>