<?php
/**
* 2007-2018 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2018 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

require_once dirname(__FILE__) . "/../../autoload.php";

class PayBySquareConfirmationModuleFrontController extends ModuleFrontController
{
    public function __construct()
    {
        $this->display_column_right = false;
        $this->display_column_left = false;

        parent::__construct();
    }

    public function postProcess()
    {
        if ((Tools::isSubmit('cart_id') == false) || (Tools::isSubmit('secure_key') == false)) {
            return false;
        }

        $cart_id = Tools::getValue('cart_id');
        $secure_key = Tools::getValue('secure_key');

        $cart = new Cart((int)$cart_id);
        $customer = new Customer((int)$cart->id_customer);

        /**
         * Since it's an example we are validating the order right here,
         * You should not do it this way in your own module.
         */
        // Default value for a payment that succeed.

        $waiting_payment_status = Configuration::get('PRESTAHELP_PAY_BY_SQUARE_WAYTING_FOR_PAYMENT');
        $message = null;


        /**
         * Converting cart into a valid order
         */
        $module_name = $this->module->displayName;
        $currency_id = (int)Context::getContext()->currency->id;

        $this->module->validateOrder(
            $cart_id,
            $waiting_payment_status,
            $cart->getOrderTotal(),
            $module_name,
            $message,
            array(),
            $currency_id,
            false,
            $secure_key
        );

        $cartId = (int) $cart_id;

        if (method_exists('Order', 'getIdByCartId')) {
            $order_id = (int) Order::getIdByCartId($cartId);
        } else {
            $order_id = (int) Order::getOrderByCartId($cartId);
        }

        if ($order_id <= 0) {
            die('Order not found for cart id ' . $cartId);
        }

        $order = new Order($order_id);

        $pbsm = new PayBySquareMails();
        $pbsm->sendOrderConfirmationMail($cartId);

        if ($secure_key == $customer->secure_key) {

            $module_id = $this->module->id;

            return Tools::redirect(
                'index.php?controller=order-confirmation&id_cart=' . $cartId .
                '&id_module=' . $module_id .
                '&id_order=' . $order_id .
                '&key=' . $secure_key
            );
        } else {

            $translation_error = 'An error occured. Please contact the merchant to have more informations';
            $this->errors[] = $this->module->l($translation_error);
            return $this->setTemplate('error.tpl');
        }

    }
}
