<?php
/**
* 2007-2018 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2018 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

class PayBySquareAPI extends Module
{
    private $username;
    private $password;
    private $basedir;
    private $baseurl;
    private $paybysquare_beneficiary;

    private $client;

    private $debug = false;

    public function __construct()
    {
        $this->username                 = Configuration::get('PRESTAHELP_PAY_BY_SQUARE_PAYBYSQUARE_USERNAME', null);
        $this->password                 = Configuration::get('PRESTAHELP_PAY_BY_SQUARE_PAYBYSQUARE_PASSWORD', null);
        $this->paybysquare_beneficiary  = Configuration::get('PRESTAHELP_PAY_BY_SQUARE_PAYBYSQUARE_BENEFICIARY', null);

        $this->basedir = _PS_ROOT_DIR_;
        $this->baseurl = Tools::getHttpHost(true). __PS_BASE_URI__;

        $this->client = new GuzzleHttp\Client(array(
                            'timeout' => 60,
                        ));
    }

    //check_by_square_credentials depricated, use camell case
    public function checkBySquareCredentials()
    {
        $url = 'https://app.bysquare.com/api/CheckLoginData';



        $xml = '<BySquareCredentials>
					<Username>' . $this->username . '</Username>
					<Password>' . $this->password . '</Password>
				</BySquareCredentials>';

        try {
            $response = $this->client->post($url, array(
                'body' => $xml,
                'headers' => array(
                    'Content-Type' =>  'text/xml',
                )
            ));
        } catch (Exception $e) {
            return false;
        }

        if ($response->getStatusCode() == 200) {
            $body = $response->getBody();
            $parsed = simplexml_load_string($body);
            return  ((String) $parsed->IsLoginDataValid == 'true');
        }
    }

    public function outputQrCodeImage($src, $id_lang = null)
    {

        $module = Module::getInstanceByName('paybysquare');
        $asdata_smarty = $module->context->smarty;
        $asdata_smarty->caching = false;

        $asdata_smarty->assign(array(
            'qr_code_src' => $src,
        ));

        return $asdata_smarty->fetch(dirname(__FILE__) . '/../views/templates/api/qr_code.tpl');
    }

    public function fetchQrcodePngInfo($id_order)
    {

        //DEBUG PURPOSES ONLY
        if ($this->debug) {
            $hash = 'debug';
            $file = 'modules/paybysquare/views/img/qr_codes/' . $hash . '.png';
            $path = $this->basedir . '/' . $file;
            $url  = $this->baseurl . $file;

            //IF FILE EXISTS RETURN FILE
            if (file_exists($path)) {
                return array( $path, $url, $hash );
            }

            exit();
        }

        //$context = Context::getContext();

        $order = new Order($id_order);

        $currency = new Currency($order->id_currency);

        //ak slovensky kod
        //echo Configuration::get('PRESTAHELP_PAY_BY_SQUARE_LANG_MODE', null)." LANGUAGE MOD";
        if(Configuration::get('PRESTAHELP_PAY_BY_SQUARE_LANG_MODE')==0) {
          $optlangsk = "true";
          $optlangcz = "false";
          $bank_accounts = $this->fetchBankDetails("SK");
        } elseif(Configuration::get('PRESTAHELP_PAY_BY_SQUARE_LANG_MODE')==1) {
          //ak cesky
          $optlangsk = "false";
          $optlangcz = "true";
          $bank_accounts = $this->fetchBankDetails("CZ");
        } else {
         //$optlangsk = "true";
         //$optlangcz = "true";
         if($currency->iso_code=="EUR") {
           $bank_accounts = $this->fetchBankDetails("SK");
           $optlangsk = "true";
           $optlangcz = "false";
         } elseif ($currency->iso_code=="CZK") {
           $bank_accounts = $this->fetchBankDetails("CZ");
           $optlangsk = "false";
           $optlangcz = "true";
         } else {
           $bank_accounts = $this->fetchBankDetails("SK");
         }
       }



        /* Parse qr code xml data*/
        $qrdata = array(
            'total' => Tools::ps_round($order->total_paid_tax_incl, 2),
            'currency' => $currency->iso_code,
            'variable_symbol' => Tools::substr(preg_replace('/[^0-9]+/', '', $order->id), 0, 10),
            'payment_note' => 'PAY by square ' . $order->id,
            'beneficiary_name' => $this->paybysquare_beneficiary,
            'bank_accounts' => $bank_accounts, // different order means different hash, but this is very marginal case
        );

        $hash = sha1(json_encode($qrdata));
        $file = 'modules/paybysquare/views/img/qr_codes/' . $hash . '.png';
        $path = $this->basedir . '/' . $file;
        $url  = $this->baseurl . $file;

        //IF FILE EXISTS RETURN FILE
        if (file_exists($path)) {
            return array( $path, $url, $hash );
        }


//. '<CurrencyCode>' .  $qrdata['currency']  . '</CurrencyCode>'
        $xml = '<BySquareXmlDocuments xmlns:xsd="http://www.w3.org/2001/XMLSchema"
                                      xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">'
            . '<Username>' . $this->username . '</Username>'
            . '<Password>' . $this->password . '</Password>'
            . '<CountryOptions>'
            . '<Slovak>'.$optlangsk.'</Slovak>'
            . '<Czech>'.$optlangcz.'</Czech>'
            . '</CountryOptions>'
            . '<Documents>'
            . '<Pay xsi:type="Pay" xmlns="http://www.bysquare.com/bysquare">'
            . '<Payments>'
            . '<Payment>'
            . '<PaymentOptions>paymentorder</PaymentOptions>'
            . '<Amount>' .  $qrdata['total']  . '</Amount>'
            . '<CurrencyCode>' .  $qrdata['currency']  . '</CurrencyCode>'
            . '<VariableSymbol>' .  $qrdata['variable_symbol']  . '</VariableSymbol>'
            . '<PaymentNote>' .  $qrdata['payment_note']  . '</PaymentNote>'
            . '<BeneficiaryName>' .  $qrdata['beneficiary_name']  . '</BeneficiaryName>'
            . '<BankAccounts>';

        foreach ($qrdata['bank_accounts'] as $bank_account) {
            $xml .= '<BankAccount>'
                . '<IBAN>' . $bank_account['iban'] . '</IBAN>'
                . '<BIC>' . $bank_account['bic'] . '</BIC>'
                . '</BankAccount>';
        }

        $xml .= '</BankAccounts>'
            . '</Payment>'
            . '</Payments>'
            . '</Pay>'
            . '</Documents>'
            . '</BySquareXmlDocuments>';

/*
echo "<pre>";
echo $xml;
echo "</pre>";
*/

        try {
            $response = $this->client->post('https://app.bysquare.com/api/generateQR', array(
                'body' => $xml,
                'headers' => array(
                    'Content-Type' =>  'text/xml',
                )
            ));
        } catch (Exception $e) {
            $response = $e->getResponse();
            $code = $response->getStatusCode();

            if (empty($code)) {
                //echo 'Paybysquare: Request failed without a code.';
                PayBySquareLog::log('Paybysquare: Request failed without a code.', $order->id);
            }

            $body = $response->getBody();
            $parsed = simplexml_load_string($body);
            if (false === $parsed) {
                //echo  'Paybysquare: Response is not valid XML (code = ' . $code . ').';
                PayBySquareLog::log('Paybysquare: Response is not valid XML (code = ' . $code . ').', $order->id, 4);
                return array();
            }
            /*
            echo "<pre>";
            print_r($parsed);
            echo "</pre>";
            die();
            */
            switch ($code) {
                case 400:
                    if (! isset($parsed->ErrorCode)) {
                        echo 'Paybysquare: Request failed with code 400 without details.';
                        PayBySquareLog::log(
                            'Paybysquare: Request failed with code 400 without details.',
                            $order->id,
                            4
                        );
                        return array();
                    }
                    if ('E601' !== "$parsed->ErrorCode") {
                        $message = empty($parsed->Message) ? '' :  ' "' . $parsed->Message . '"';
                        $detail = empty($parsed->Detail) ? '' : ' (' . $parsed->Detail . ')';
                        PayBySquareLog::log(
                            'Paybysquare: Request failed with code 400 with error ' .
                            $parsed->ErrorCode . $message . $detail . '.',
                            $order->id,
                            4
                        );

                        //Turn off payment
                        Configuration::set('PRESTAHELP_PAY_BY_SQUARE_LIVE_MODE', false);

                        return array();
                    }

                    PayBySquareLog::log(
                        'Paybysquare: Montly limit was reached (HTTP=400 ErrorCode=E601).',
                        $order->id,
                        4
                    );

                    return array();
                case 401:
                    PayBySquareLog::log(
                        'Paybysquare: Username and Password pair does not exists or is disabled.',
                        $order->id,
                        4
                    );

                    return array();
                default:
                    PayBySquareLog::log(
                        'Paybysquare: Request failed with code "' . $code . '".',
                        $order->id,
                        4
                    );

                    return array();
            }
        }

        /* Everithing went OK save file */
        if ($response->getStatusCode() == 200) {
            $body = $response->getBody();
            $parsed = simplexml_load_string($body);
            if (! isset($parsed->PayBySquare)) {
                PayBySquareLog::log(
                    'Paybysquare: Response is missing paybysquare code.',
                    $order->id,
                    4
                );

                return array();
            }
            if (Configuration::get('PRESTAHELP_PAY_BY_SQUARE_LANG_MODE')==0){
              if($qrdata['currency']=="EUR") {
                $qrtoparse = $parsed->PayBySquare;
              }
            } elseif (Configuration::get('PRESTAHELP_PAY_BY_SQUARE_LANG_MODE')==1){
              if ($qrdata['currency']=="CZK") {
                $qrtoparse = $parsed->QrPlatbaCz;
              }
            } elseif (Configuration::get('PRESTAHELP_PAY_BY_SQUARE_LANG_MODE')==2){
              if($qrdata['currency']=="EUR") {
                $qrtoparse = $parsed->PayBySquare;
              } elseif ($qrdata['currency']=="CZK") {
                $qrtoparse = $parsed->QrPlatbaCz;
              } else {
                //$qrtoparse = $parsed->PayBySquare;
              }
            }

            if (false === file_put_contents($path, base64_decode($qrtoparse), LOCK_EX)) {
                PayBySquareLog::log(
                    'Paybysquare: Unable to write QR code into file: ' . $path,
                    $order->id,
                    4
                );

                return array();
            }
        }

        return array( $path, $url, $hash );
    }

    /* Get Bank accounts */
    public function fetchBankDetails($krajinaucet)
    {
        $context = Context::getContext();
        $id_shop = $context->shop->id;

        $_account = Configuration::get('PRESTAHELP_PAY_BY_SQUARE_IBAN');
        $__accounts = explode(PHP_EOL,$_account);
        $bank_accountssk = array();
        $bank_accountscz = array();
        //$accounts = $__accounts[1];
        $bank_accounts = array();
        foreach($__accounts as $__account) {
          if(!empty($__account)) {

            $account = explode(";", $__account);
            //zistenie, ci je cesky, alebo slovensky ucet
            $iibaan = trim($account[0]);
            $iibaan = substr($iibaan,0,2);

              if($iibaan=="SK") {
                $bank_accountssk[] = array(
                    'iban' => trim($account[0]),
                    'bic' => trim($account[1]),
                    'account_name' => trim($account[2])
                );
              }
              if($iibaan=="CZ") {
                $bank_accountscz[] = array(
                    'iban' => trim($account[0]),
                    'bic' => trim($account[1]),
                    'account_name' => trim($account[2])
                );
              }
          }
        }

        if ($krajinaucet == "CZ") {
            $bank_accounts = array_merge((array)$bank_accountscz, (array)$bank_accountssk);
        } else {
            // default SK + fallback
            $bank_accounts = array_merge((array)$bank_accountssk, (array)$bank_accountscz);
        }
        return $bank_accounts;

    }
}
